﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace Percent___Qualification_work.userControls
{
    public partial class ucDay : UserControl
    {
        string _day;

        public ucDay(string day)
        {
            InitializeComponent();
            _day = day;
            cButton.Text = day.PadLeft(2, ' ');
        }

        public void cButton_Click(object sender, EventArgs e)
        {
            string date = Calendar._year.ToString() + "-" + Calendar._month.ToString() + "-" + _day;
            
        }

        private void HighlightSundays()
        {
            // Check if the current day is a valid number and if it can be parsed as a date
            if (int.TryParse(_day, out int dayNumber) && Calendar._month > 0 && Calendar._year > 0)
            {
                DateTime date = new DateTime(Calendar._year, Calendar._month, dayNumber);

                // Check if the day is Sunday
                if (date.DayOfWeek == DayOfWeek.Sunday)
                {
                    cButton.ForeColor = Color.FromArgb(255, 128, 128); // Light Red for Sundays
                    
                }
                else
                {
                    cButton.ForeColor = Color.FromArgb(64, 64, 64); // Default color for other days
                }
            }
        }

        private void ucDay_Load(object sender, EventArgs e)
        {
            HighlightSundays();
        }
    }
}
